<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Leaderboard extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'user_id' => [
                'type'       => 'INT',
                'unsigned'   => true,
            ],
            'current_money' => [
                'type' => 'int',
            ],
            'most_money' => [
                'type' => 'int',
            ],
            'biggest_win' => [
                'type' => 'int',
            ],
            'biggest_loss' => [
                'type' => 'int',
            ],
            'biggest_winstreak' => [
                'type' => 'int',
            ],
            'biggest_losstreak' => [
                'type' => 'int',
            ],

        ]);

        $this->forge->addKey('id', TRUE);
        //$this->forge->addForeignKey('user_id', 'users', 'id', 'CASCADE', 'CASCADE', 'user_id_fk');
        //$this->forge->addForeignKey('current_money', 'users', 'money', 'CASCADE', 'CASCADE', 'user_money_fk');

        $this->forge->createTable('leaderboard');

    }

    public function down()
    {
        $this->forge->dropTable('leaderboard');
    }
}
